#!/usr/bin/env bash
set -euo pipefail

JAR_NAME="XygeniLocalScanner-1.0.0.jar"

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
cd "$SCRIPT_DIR"

java \
  --module-path "javafx/lib" \
  --add-modules javafx.controls,javafx.fxml,javafx.web \
  -Djava.library.path="javafx/bin" \
  --enable-native-access=javafx.graphics \
  --enable-native-access=javafx.web \
  -jar "$JAR_NAME"

