/*
 * Decompiled with CFR 0.152.
 */
package dev.xygeni.desktop.url.controller;

import dev.xygeni.desktop.log.controller.LogController;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import javafx.concurrent.Task;

public class URLController {
    LogController logController;

    public URLController(LogController logController) {
        this.logController = logController;
    }

    private String sanitizeUrl(String url) {
        Object u;
        Object object = u = url == null ? "" : url.trim();
        if (!((String)u).matches("(?i)^[a-z][a-z0-9+.-]*://.*")) {
            u = "https://" + (String)u;
        }
        u = ((String)u).replace(" ", "%20");
        return u;
    }

    public void openURL(String url) {
        this.logController.generateLog("INFO", "Opening the URL: " + url);
        url = this.sanitizeUrl(url);
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("nux")) {
            final String finalUrl = url;
            Task<Void> openingUrl = new Task<Void>(){

                protected Void call() {
                    try {
                        new ProcessBuilder("xdg-open", finalUrl).inheritIO().start();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            };
            Thread t = new Thread((Runnable)openingUrl, "opening-url-thread");
            t.start();
            this.logController.generateLog("INFO", "URL " + url + " was opened using xdg-open");
            return;
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    desktop.browse(new URI(url));
                    this.logController.generateLog("INFO", "URL " + url + " was open correctly");
                    return;
                }
                this.logController.generateLog("ERROR", "URL " + url + " was not open correctly DESKTOP does not contains BROWSE Action");
            } else {
                this.logController.generateLog("ERROR", "URL " + url + " was not open correctly DESKTOP action is not supported");
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            this.logController.generateLog("ERROR", "URL " + url + " was not open correctly. Unhandled exceptions has been raised " + String.valueOf(e));
            throw new RuntimeException();
        }
    }
}

