/*
 * Decompiled with CFR 0.152.
 */
package dev.xygeni.desktop.ui.controller;

import dev.xygeni.desktop.api.controller.APIController;
import dev.xygeni.desktop.command.controller.TaskController;
import dev.xygeni.desktop.log.controller.LogController;
import dev.xygeni.desktop.url.controller.URLController;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.PauseTransition;
import javafx.beans.property.Property;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.Pair;

public class MainController {
    private String api_token;
    private boolean running = false;
    private boolean localScan = true;
    Task<Integer> scanTask = null;
    private String xygeni_path;
    LogController logController;
    TaskController scanTaskController;
    private Thread validateThread;
    private Thread scanThread;
    private Task<Void> validateTask;
    @FXML
    private Button analyzeBtn;
    @FXML
    private Button exitBtn;
    @FXML
    private TextField applicationTextField;
    @FXML
    private CheckBox complianceCheckbox;
    @FXML
    private Button directorySearchBtn;
    @FXML
    private Button helpBtn;
    @FXML
    private CheckBox iacCheckbox;
    @FXML
    private CheckBox inventoryCheckbox;
    @FXML
    private RadioButton localBtn;
    @FXML
    private Text locationLabel;
    @FXML
    private TextField locationTextField;
    @FXML
    private ToggleGroup location_scan;
    @FXML
    private CheckBox malwareCheckbox;
    @FXML
    private CheckBox misconfCheckbox;
    @FXML
    private RadioButton remoteBtn;
    @FXML
    private CheckBox sastCheckbox;
    @FXML
    private CheckBox scaCheckbox;
    @FXML
    private CheckBox secretsCheckbox;
    @FXML
    private Button openResultsBtn;
    @FXML
    private TextArea resultsTextArea;
    @FXML
    private TextField tokenField;
    @FXML
    private CheckBox viewCheckBox;
    private PasswordField passwordField = new PasswordField();

    public MainController(LogController logController) {
        this.logController = logController;
    }

    public void setXygeni_path(String path) {
        this.xygeni_path = path;
    }

    @FXML
    private void initialize() {
        this.openResultsBtn.setDisable(true);
        this.resultsTextArea.setEditable(false);
        this.passwordField = new PasswordField();
        this.passwordField.setPromptText(this.tokenField.getPromptText());
        this.passwordField.textProperty().bindBidirectional((Property)this.tokenField.textProperty());
        HBox parent = (HBox)this.tokenField.getParent();
        int index = parent.getChildren().indexOf((Object)this.tokenField);
        parent.getChildren().add(index + 1, (Object)this.passwordField);
        HBox.setHgrow((Node)this.passwordField, (Priority)HBox.getHgrow((Node)this.tokenField));
        this.passwordField.setVisible(true);
        this.passwordField.setManaged(true);
        this.tokenField.setVisible(false);
        this.tokenField.setManaged(false);
        this.logController.generateLog("INFO", "Extracting XYGENI_TOKEN from Environment variable");
        String xygeni_token_var = System.getenv("XYGENI_TOKEN");
        if (xygeni_token_var != null) {
            this.tokenField.setText(xygeni_token_var);
            this.startValidateTask();
        }
        this.viewCheckBox.selectedProperty().addListener((obs, oldVal, show) -> {
            if (show.booleanValue()) {
                this.tokenField.setVisible(true);
                this.tokenField.setManaged(true);
                this.passwordField.setVisible(false);
                this.passwordField.setManaged(false);
                this.tokenField.requestFocus();
            } else {
                this.tokenField.setVisible(false);
                this.tokenField.setManaged(false);
                this.passwordField.setVisible(true);
                this.passwordField.setManaged(true);
                this.passwordField.requestFocus();
            }
        });
        PauseTransition pause = new PauseTransition(Duration.millis((double)500.0));
        this.tokenField.textProperty().addListener((obs, oldText, newText) -> {
            this.handleTyping();
            pause.setOnFinished(e -> this.startValidateTask());
            pause.playFromStart();
        });
        this.passwordField.textProperty().addListener((obs, oldText, newText) -> {
            this.handleTyping();
            pause.setOnFinished(e -> this.startValidateTask());
            pause.playFromStart();
        });
        this.locationTextField.focusedProperty().addListener((obs, oldText, newText) -> {
            if (this.locationTextField.getText().isEmpty()) {
                return;
            }
            if (this.localScan && this.isNotValidPath()) {
                this.locationTextField.getStyleClass().add((Object)"textfield-red");
            } else if (!this.localScan && this.isNotValidURL()) {
                this.locationTextField.getStyleClass().add((Object)"textfield-red");
            } else {
                this.locationTextField.getStyleClass().removeAll((Object[])new String[]{"textfield-green", "textfield-red"});
            }
        });
    }

    private void startValidateTask() {
        if (this.validateTask != null && this.validateTask.isRunning()) {
            this.validateTask.cancel();
            if (this.validateThread != null && this.validateThread.isAlive()) {
                this.validateThread.interrupt();
            }
        }
        this.validateTask = new Task<Void>(){

            protected Void call() {
                if (this.isCancelled() || Thread.currentThread().isInterrupted()) {
                    return null;
                }
                MainController.this.validateToken();
                return null;
            }
        };
        this.validateThread = new Thread((Runnable)this.validateTask, "xygeni-validate-task");
        this.validateThread.setDaemon(true);
        this.validateThread.start();
    }

    private void handleTyping() {
        this.tokenField.getStyleClass().removeAll((Object[])new String[]{"textfield-green", "textfield-red"});
        this.passwordField.getStyleClass().removeAll((Object[])new String[]{"textfield-green", "textfield-red"});
    }

    private void validateToken() {
        boolean isTokenValid;
        this.logController.generateLog("INFO", "Validating token");
        try {
            isTokenValid = this.isValidToken(false);
        }
        catch (Exception e) {
            isTokenValid = false;
        }
        if (isTokenValid) {
            this.logController.generateLog("INFO", "Token is valid");
            this.tokenField.getStyleClass().add((Object)"textfield-green");
            this.passwordField.getStyleClass().add((Object)"textfield-green");
        } else {
            this.logController.generateLog("INFO", "Token is not valid");
            this.tokenField.getStyleClass().add((Object)"textfield-red");
            this.passwordField.getStyleClass().add((Object)"textfield-red");
        }
    }

    private boolean isNotValidPath() {
        Path path = Paths.get(this.locationTextField.getText(), new String[0]);
        return !Files.exists(path, new LinkOption[0]) || Objects.equals(this.locationTextField.getText(), "");
    }

    private boolean isNotValidURL() {
        try {
            new URL(this.locationTextField.getText()).toURI();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean isValidAppName() {
        return this.applicationTextField.getText().matches("[a-zA-Z0-9_\\- /]{0,256}");
    }

    private boolean isValidToken(boolean launch_alerts) {
        Alert alert;
        String response_body;
        int token_valid;
        APIController apiController = new APIController();
        this.api_token = this.passwordField.getText();
        try {
            Pair<Integer, String> api_token_results = apiController.checkAPIToken(this.api_token);
            token_valid = (Integer)api_token_results.getKey();
            response_body = (String)api_token_results.getValue();
        }
        catch (IOException | InterruptedException e) {
            this.logController.generateLog("ERROR", "Exception launched during api communication");
            throw new RuntimeException(e);
        }
        if (token_valid == 0) {
            this.logController.generateLog("INFO", "API return 200 OK");
            return true;
        }
        if (token_valid == 1) {
            this.logController.generateLog("INFO", "API return 401 Unauthorized");
            if (launch_alerts) {
                alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Invalid Token");
                alert.setHeaderText("Invalid Token");
                alert.setContentText("The token that has been provided is invalid or has expired. Please check the validity of this token");
                Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
                stage.getIcons().add((Object)new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/icons/only-logo.png"))));
                alert.showAndWait();
            }
            return false;
        }
        this.logController.generateLog("WARNING", "API return an unexpected response" + response_body);
        if (launch_alerts) {
            alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Unexpected Error");
            alert.setHeaderText("Unexpected Error with the token");
            alert.setContentText("An unexpected error with the token has occurred. Please try again or reload the application.\n" + response_body);
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/icons/only-logo.png"))));
            alert.showAndWait();
        }
        return false;
    }

    private String constructCommand() {
        if (!this.isValidToken(true)) {
            return null;
        }
        Object command = String.format("%s --token='%s' scan ", this.xygeni_path, this.api_token);
        if (this.localScan && this.isNotValidPath()) {
            this.locationTextField.getStyleClass().add((Object)"textfield-red");
            this.logController.generateLog("INFO", "Introduced Path is not valid");
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Invalid Path");
            alert.setHeaderText("Invalid Path");
            alert.setContentText("The provided path does not exists or is not accessible.");
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/icons/only-logo.png"))));
            alert.showAndWait();
            return null;
        }
        if (!this.localScan && this.isNotValidURL()) {
            this.logController.generateLog("INFO", "Introduced URL is not valid");
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Invalid Repository URL");
            alert.setHeaderText("Invalid Repository URL");
            alert.setContentText("The provided Repository URL is not a valid URL.");
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/icons/only-logo.png"))));
            alert.showAndWait();
            return null;
        }
        if (!this.isValidAppName()) {
            this.logController.generateLog("INFO", "Introduced Name is not valid");
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Invalid Application Name");
            alert.setHeaderText("Invalid Application Name");
            alert.setContentText("The provided Application Name contains invalid characters.");
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/icons/only-logo.png"))));
            alert.showAndWait();
            return null;
        }
        this.locationTextField.getStyleClass().removeAll((Object[])new String[]{"textfield-green", "textfield-red"});
        Boolean sast = this.sastCheckbox.isSelected();
        Boolean sca = this.scaCheckbox.isSelected();
        Boolean malware = this.malwareCheckbox.isSelected();
        Boolean iac = this.iacCheckbox.isSelected();
        Boolean secrets = this.secretsCheckbox.isSelected();
        Boolean compliance = this.complianceCheckbox.isSelected();
        Boolean inventory = this.inventoryCheckbox.isSelected();
        Boolean misconf = this.misconfCheckbox.isSelected();
        if (!(sast.booleanValue() || sca.booleanValue() || malware.booleanValue() || iac.booleanValue() || secrets.booleanValue() || compliance.booleanValue() || inventory.booleanValue() || misconf.booleanValue())) {
            return null;
        }
        command = this.localScan ? (String)command + String.format("-d='%s' ", this.locationTextField.getText()) : (String)command + String.format("-repo='%s' ", this.locationTextField.getText());
        if (!Objects.equals(this.applicationTextField.getText(), "")) {
            command = (String)command + String.format("-n='%s' ", this.applicationTextField.getText());
        }
        StringBuilder runArgs = new StringBuilder("--run='");
        if (sast.booleanValue()) {
            runArgs.append("sast,");
        }
        if (sca.booleanValue()) {
            runArgs.append("deps,suspectdeps,");
        }
        if (malware.booleanValue()) {
            runArgs.append("malware,");
        }
        if (iac.booleanValue()) {
            runArgs.append("iac,");
        }
        if (secrets.booleanValue()) {
            runArgs.append("secrets,");
        }
        if (compliance.booleanValue()) {
            runArgs.append("compliance,");
        }
        if (inventory.booleanValue()) {
            runArgs.append("inventory,");
        }
        if (misconf.booleanValue()) {
            runArgs.append("misconf,");
        }
        if (runArgs.charAt(runArgs.length() - 1) == ',') {
            runArgs.deleteCharAt(runArgs.length() - 1);
        }
        runArgs.append("' ");
        command = (String)command + runArgs.toString();
        return command;
    }

    @FXML
    void analyzeBtn_onAction(ActionEvent event) {
        if (!this.running) {
            this.scanTaskController = new TaskController();
            this.logController.generateLog("INFO", "Building Scan command");
            String command = this.constructCommand();
            if (command == null) {
                return;
            }
            this.logController.generateLog("INFO", "Launching Scan");
            String name = "";
            if (!Objects.equals(this.applicationTextField.getText(), "")) {
                name = this.applicationTextField.getText();
            } else if (this.localScan) {
                name = Paths.get(this.locationTextField.getText(), new String[0]).getFileName().toString();
            } else {
                String url = this.locationTextField.getText();
                String regex = ".*/([^/]+/[^/]+)$";
                Matcher m = Pattern.compile(regex).matcher(url);
                if (m.find()) {
                    name = m.group(1);
                }
            }
            this.scanTask = this.scanTaskController.createCommandTask(command, this.resultsTextArea, this.analyzeBtn, this.openResultsBtn, name);
            this.scanThread = new Thread((Runnable)this.scanTask, "xygeni-scan-task");
            this.scanThread.setDaemon(true);
            this.scanThread.start();
            this.running = true;
        } else if (this.scanTask != null && this.scanTask.isRunning()) {
            this.logController.generateLog("INFO", "Cancelling Scan");
            this.scanTask.cancel(true);
            this.analyzeBtn.setText("Launch Scan");
            this.running = false;
        } else {
            this.running = false;
            this.analyzeBtn_onAction(event);
        }
    }

    @FXML
    void helpBtn_onAction(ActionEvent event) {
        URLController urlController = new URLController(this.logController);
        urlController.openURL("https://docs.xygeni.io/xygeni-scanner-cli/xygeni-cli-overview/xygeni-scanner-gui");
    }

    @FXML
    void directorySearchBtn_onAction(ActionEvent event) {
        Stage stage;
        File folder;
        this.logController.generateLog("INFO", "Choosing directory from Explorer");
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setTitle("Select a directory");
        File home = new File(System.getProperty("user.home"));
        if (home.exists() && home.isDirectory()) {
            chooser.setInitialDirectory(home);
        }
        if ((folder = chooser.showDialog((Window)(stage = (Stage)((Node)event.getSource()).getScene().getWindow()))) != null) {
            this.locationTextField.setText(folder.getAbsolutePath());
        }
    }

    @FXML
    void openResultsBtn_onAction(ActionEvent event) {
        this.logController.generateLog("INFO", "Trying to open the results URL");
        if (this.scanTask == null) {
            this.logController.generateLog("INFO", "Scan Task was not launched (Task is null)");
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Scan Not Started");
            alert.setHeaderText("Results Unavailable");
            alert.setContentText("The scan results cannot be displayed because the scan process has not started yet. Please start the scan before checking the results.");
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/icons/only-logo.png"))));
            alert.showAndWait();
        } else if (!this.scanTask.isDone()) {
            this.logController.generateLog("INFO", "Scan Task is not Done. Please wait until the scan finishes.");
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Scan In Progress");
            alert.setHeaderText("Results Unavailable");
            alert.setContentText("The scan is still running. The results will be available once the process is complete. Please wait until the scan finishes.");
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/icons/only-logo.png"))));
            alert.showAndWait();
        } else if (this.scanTask.getState() != Worker.State.SUCCEEDED) {
            this.logController.generateLog("INFO", "The scan task has failed or it was cancelled. Please retry the scan.");
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Scan Unsuccessful");
            alert.setHeaderText("Results Unavailable");
            alert.setContentText("The scan did not complete successfully. Results are unavailable at this time. Please try to scan again later.");
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/icons/only-logo.png"))));
            alert.showAndWait();
        } else {
            URLController urlController = new URLController(this.logController);
            urlController.openURL(this.scanTaskController.getResultURL());
        }
    }

    @FXML
    void toggleScanLocation_onAction(ActionEvent event) {
        if (event.getSource() == this.localBtn) {
            this.logController.generateLog("INFO", "Changing to local Scan");
            this.localScan = true;
            this.locationLabel.setText("Directory Path*:");
            this.locationTextField.clear();
            this.directorySearchBtn.setDisable(false);
        } else if (event.getSource() == this.remoteBtn) {
            this.logController.generateLog("INFO", "Changing to remote Scan");
            this.localScan = false;
            this.locationLabel.setText("Repository URL*:");
            this.locationTextField.clear();
            this.directorySearchBtn.setDisable(true);
        }
    }

    @FXML
    void exitBtn_onAction(ActionEvent event) {
        if (this.validateThread != null && this.validateThread.isAlive()) {
            this.validateThread.interrupt();
        }
        if (this.scanThread != null && this.scanThread.isAlive()) {
            this.scanThread.interrupt();
        }
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }
}

