/*
 * Decompiled with CFR 0.152.
 */
package dev.xygeni.desktop.log.controller;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LogController {
    String folder;
    File logFile;

    public LogController() {
        String userHome = System.getProperty("user.home");
        this.folder = userHome + File.separator + ".XygeniLocalScanner" + File.separator + "logs";
        this.initialize();
    }

    public void initialize() {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        String fileName = this.folder + "/log_" + timestamp + ".log";
        File dir = new File(this.folder);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Failed to create log directory: " + this.folder);
        }
        this.logFile = new File(fileName);
        try {
            if (!this.logFile.createNewFile()) {
                throw new RuntimeException("Failed to create log file: " + fileName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void generateLog(String type, String message) {
        String logLine = String.format("%s [%s] %s%n", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), type, message);
        try (FileWriter fw = new FileWriter(this.logFile, true);){
            fw.write(logLine);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

