/*
 * Decompiled with CFR 0.152.
 */
package dev.xygeni.desktop.command.controller;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;

public class TaskController {
    TextArea resultsTextArea;
    Button analyzeBtn;
    String resultURL;
    Button openResultsBtn;

    public String getResultURL() {
        return this.resultURL;
    }

    private String maskToken(String command) {
        Pattern p = Pattern.compile("(--token=)(['\"]?)([^\\s'\"]+)(\\2)");
        Matcher m = p.matcher(command);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String token = m.group(3);
            String masked = token.length() > 8 ? token.substring(0, 4) + "..." + token.substring(token.length() - 4) : token;
            String replacement = m.group(1) + m.group(2) + masked + m.group(2);
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public Task<Integer> createCommandTask(String command, TextArea textarea, Button scanBtn, Button resultBtn, String name) {
        this.analyzeBtn = scanBtn;
        this.resultsTextArea = textarea;
        this.openResultsBtn = resultBtn;
        this.openResultsBtn.setDisable(true);
        String os = System.getProperty("os.name").toLowerCase();
        this.resultsTextArea.clear();
        this.resultsTextArea.setStyle("-fx-font-family: 'Lucida Console';-fx-font-size: 12;");
        this.resultsTextArea.appendText(this.maskToken(command) + System.lineSeparator() + System.lineSeparator());
        this.analyzeBtn.setText("Cancel");
        this.resultURL = null;
        if (os.contains("win")) {
            return this.createCommandTaskWindows(command, name);
        }
        return this.createCommandTaskLinux(command, name);
    }

    private Task<Integer> createCommandTaskWindows(final String command, final String name) {
        return new Task<Integer>(){

            protected Integer call() throws Exception {
                String exe = "powershell.exe";
                ProcessBuilder pb = new ProcessBuilder(exe, "-NoProfile", "-ExecutionPolicy", "Bypass", "-Command", command);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                boolean cancelled = false;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (this.isCancelled() || Thread.currentThread().isInterrupted()) {
                            cancelled = true;
                            process.destroyForcibly();
                            if (Thread.currentThread().isInterrupted()) {
                                Thread.currentThread().interrupt();
                            }
                            break;
                        }
                        String l = line.replaceAll("\u001b\\[[;\\d]*m", "");
                        if (TaskController.this.resultsTextArea == null) continue;
                        Platform.runLater(() -> {
                            TaskController.this.resultsTextArea.appendText(l + System.lineSeparator());
                            TaskController.this.resultsTextArea.positionCaret(TaskController.this.resultsTextArea.getText().length());
                        });
                    }
                }
                if (cancelled) {
                    return -1;
                }
                try {
                    return process.waitFor();
                }
                catch (InterruptedException ie) {
                    process.destroyForcibly();
                    Thread.currentThread().interrupt();
                    return -1;
                }
            }

            protected void succeeded() {
                TaskController.this.resultURL = "https://in.xygeni.io/dashboard/risks/all-risks?project=" + name;
                TaskController.this.analyzeBtn.setText("Launch Scan");
                TaskController.this.resultsTextArea.appendText("\n-- Command completed correctly --\n");
                TaskController.this.openResultsBtn.setDisable(false);
            }

            protected void failed() {
                TaskController.this.analyzeBtn.setText("Launch Scan");
                TaskController.this.resultsTextArea.appendText("\n-- Error at executing the command --\n");
            }

            protected void cancelled() {
                TaskController.this.analyzeBtn.setText("Launch Scan");
                TaskController.this.resultsTextArea.appendText("\n-- Execution Cancelled --\n");
            }
        };
    }

    private Task<Integer> createCommandTaskLinux(final String command, final String name) {
        return new Task<Integer>(){

            protected Integer call() throws Exception {
                String exe = "/bin/bash";
                ProcessBuilder pb = new ProcessBuilder(exe, "-lc", command);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                boolean cancelled = false;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (this.isCancelled() || Thread.currentThread().isInterrupted()) {
                            cancelled = true;
                            process.destroyForcibly();
                            if (Thread.currentThread().isInterrupted()) {
                                Thread.currentThread().interrupt();
                            }
                            break;
                        }
                        String l = line.replaceAll("\u001b\\[[;\\d]*m", "");
                        if (TaskController.this.resultsTextArea == null) continue;
                        Platform.runLater(() -> {
                            TaskController.this.resultsTextArea.appendText(l + System.lineSeparator());
                            TaskController.this.resultsTextArea.positionCaret(TaskController.this.resultsTextArea.getText().length());
                        });
                    }
                }
                if (cancelled) {
                    return -1;
                }
                try {
                    return process.waitFor();
                }
                catch (InterruptedException ie) {
                    process.destroyForcibly();
                    Thread.currentThread().interrupt();
                    return -1;
                }
            }

            protected void succeeded() {
                TaskController.this.resultURL = "https://in.xygeni.io/dashboard/risks/all-risks?project=" + name;
                TaskController.this.analyzeBtn.setText("Launch Scan");
                TaskController.this.resultsTextArea.appendText("\n-- Command completed correctly --\n");
                TaskController.this.openResultsBtn.setDisable(false);
            }

            protected void failed() {
                TaskController.this.analyzeBtn.setText("Launch Scan");
                TaskController.this.resultsTextArea.appendText("\n-- Error while executing the command --\n");
            }

            protected void cancelled() {
                TaskController.this.analyzeBtn.setText("Launch Scan");
                TaskController.this.resultsTextArea.appendText("\n-- Execution cancelled --\n");
            }
        };
    }
}

