/*
 * Decompiled with CFR 0.152.
 */
package dev.xygeni.desktop.command.controller;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class CommandChecker {
    public static boolean commandExists(String command) {
        if (command == null || command.isBlank()) {
            return false;
        }
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.contains("win");
        if (CommandChecker.isLikelyPath(command)) {
            return isWindows ? CommandChecker.existsAndExecutablePathWindows(command) : CommandChecker.existsAndExecutablePathPosix(command);
        }
        return isWindows ? CommandChecker.commandExistsWindows(command) : CommandChecker.commandExistsLinux(command);
    }

    private static boolean commandExistsWindows(String command) {
        String escaped = CommandChecker.escapeForPowerShellSingleQuoted(command);
        String ps = "if (Get-Command -Name '" + escaped + "' -ErrorAction SilentlyContinue) { exit 0 } else { exit 1 }";
        String[] cmd = new String[]{"powershell", "-NoProfile", "-NonInteractive", "-Command", ps};
        try {
            Process process = new ProcessBuilder(cmd).start();
            int exit = process.waitFor();
            return exit == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    private static boolean commandExistsLinux(String command) {
        String[] cmd = new String[]{"bash", "-lc", "command -v '" + CommandChecker.escapeForSingleQuotes(command) + "' >/dev/null 2>&1"};
        try {
            Process process = new ProcessBuilder(cmd).start();
            int exit = process.waitFor();
            return exit == 0;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    private static boolean existsAndExecutablePathWindows(String inputPath) {
        String[] stringArray;
        File f = new File(inputPath);
        if (f.isFile()) {
            return true;
        }
        String pathext = System.getenv("PATHEXT");
        if (pathext != null && !pathext.isBlank()) {
            stringArray = pathext.split(";", -1);
        } else {
            String[] stringArray2 = new String[5];
            stringArray2[0] = ".EXE";
            stringArray2[1] = ".BAT";
            stringArray2[2] = ".CMD";
            stringArray2[3] = ".COM";
            stringArray = stringArray2;
            stringArray2[4] = ".PS1";
        }
        String[] extensions = stringArray;
        String nameUpper = inputPath.toUpperCase();
        for (String ext : extensions) {
            if (!nameUpper.endsWith(ext)) continue;
            return false;
        }
        for (String ext : extensions) {
            File fileWithExtension = new File(inputPath + ext);
            if (!fileWithExtension.isFile()) continue;
            return true;
        }
        return false;
    }

    private static boolean existsAndExecutablePathPosix(String inputPath) {
        Path p = new File(inputPath).toPath();
        return Files.isRegularFile(p, new LinkOption[0]) && Files.isExecutable(p);
    }

    private static boolean isLikelyPath(String s) {
        return s.contains("/") || s.contains("\\") || s.startsWith(".") || s.startsWith("~") || s.matches("(?i)^[a-z]:.*") || s.startsWith("\\\\");
    }

    private static String escapeForSingleQuotes(String s) {
        return s.replace("'", "'\"'\"'");
    }

    private static String escapeForPowerShellSingleQuoted(String s) {
        return s.replace("'", "''");
    }
}

