/*
 * Decompiled with CFR 0.152.
 */
package dev.xygeni.desktop;

import dev.xygeni.desktop.command.controller.CommandChecker;
import dev.xygeni.desktop.log.controller.LogController;
import dev.xygeni.desktop.ui.controller.InstallingController;
import dev.xygeni.desktop.ui.controller.MainController;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.application.Application;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.stage.Window;

public class MainApp
extends Application {
    private LogController logController;

    private static void unzip(Path zipFilePath, Path outputPath) throws IOException {
        if (!Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath.toFile()));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path newFilePath = outputPath.resolve(entry.getName()).normalize();
                if (!newFilePath.startsWith(outputPath)) {
                    throw new IOException(entry.getName());
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(newFilePath, new FileAttribute[0]);
                } else {
                    if (newFilePath.getParent() != null) {
                        Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
                    }
                    try (OutputStream out = Files.newOutputStream(newFilePath, new OpenOption[0]);){
                        zis.transferTo(out);
                    }
                }
                zis.closeEntry();
            }
        }
    }

    public void start(Stage stage) throws Exception {
        this.logController = new LogController();
        Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/fonts/cambria-math.ttf"), (double)12.0);
        Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/fonts/lucon.ttf"), (double)12.0);
        String userHome = System.getProperty("user.home");
        final Path baseDir = Paths.get(userHome, ".XygeniLocalScanner");
        Files.createDirectories(baseDir, new FileAttribute[0]);
        Path scannerDir = baseDir.resolve("xygeni_scanner");
        final String winPath = scannerDir.resolve("xygeni.ps1").toString();
        final String nixPath = scannerDir.resolve("xygeni").toString();
        boolean hasPathCmd = CommandChecker.commandExists("xygeni");
        boolean hasLocalWin = CommandChecker.commandExists(winPath);
        boolean hasLocalNix = CommandChecker.commandExists(nixPath);
        stage.setTitle("Xygeni Local Scanner");
        stage.getIcons().add((Object)new Image(Objects.requireNonNull(((Object)((Object)this)).getClass().getResourceAsStream("/icons/only-logo.png"))));
        if (hasPathCmd || hasLocalWin || hasLocalNix) {
            if (hasPathCmd) {
                this.logController.generateLog("INFO", "Xygeni Scanner was detected on the PATH");
            } else {
                this.logController.generateLog("INFO", "Xygeni Scanner was detected locally");
            }
            String os = System.getProperty("os.name").toLowerCase();
            String resolvedPath = hasPathCmd ? "xygeni" : (os.contains("win") ? winPath : nixPath);
            FXMLLoader mainLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/main-view.fxml"));
            mainLoader.setControllerFactory(type -> {
                if (type == MainController.class) {
                    return new MainController(this.logController);
                }
                try {
                    return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent mainRoot = (Parent)mainLoader.load();
            MainController mainController = (MainController)mainLoader.getController();
            mainController.setXygeni_path(resolvedPath);
            Scene mainScene = new Scene(mainRoot, 900.0, 700.0);
            stage.setScene(mainScene);
            stage.show();
            stage.setMinWidth(780.0);
            stage.setMinHeight(600.0);
            this.logController.generateLog("INFO", "Stage Created");
            return;
        }
        this.logController.generateLog("INFO", "Xygeni Scanner was not detected on the PATH or locally. The installation of the Scanner will start now.");
        FXMLLoader installingLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/installing-view.fxml"));
        Parent installingRoot = (Parent)installingLoader.load();
        Object ctrl = installingLoader.getController();
        Scene installingScene = new Scene(installingRoot, 900.0, 700.0);
        stage.setScene(installingScene);
        stage.show();
        Task<String> downloadTask = new Task<String>(){

            protected String call() {
                try {
                    boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
                    this.updateMessage("Downloading Xygeni scanner 0%...");
                    MainApp.this.logController.generateLog("INFO", "Starting the Xygeni Scanner Download");
                    URL url = new URL("https://get.xygeni.io/latest/scanner/xygeni-release.zip");
                    Path zipPath = baseDir.resolve("xygeni-release.zip");
                    URLConnection connection = url.openConnection();
                    int contentLength = connection.getContentLength();
                    try (InputStream in = connection.getInputStream();
                         OutputStream out = Files.newOutputStream(zipPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        int bytesRead;
                        byte[] buffer = new byte[8192];
                        long bytesReadTotal = 0L;
                        long lastUpdate = 0L;
                        while ((bytesRead = in.read(buffer)) != -1) {
                            out.write(buffer, 0, bytesRead);
                            bytesReadTotal += (long)bytesRead;
                            if (contentLength > 0) {
                                double progress = (double)bytesReadTotal / (double)contentLength;
                                this.updateProgress(bytesReadTotal, contentLength);
                                long now = System.currentTimeMillis();
                                if (now - lastUpdate <= 500L) continue;
                                this.updateMessage(String.format("Downloading Xygeni scanner %.1f%%...", progress * 100.0));
                                lastUpdate = now;
                                continue;
                            }
                            this.updateMessage(String.format("Downloading Xygeni scanner (%.2f MB downloaded)...", (double)bytesReadTotal / 1000000.0));
                        }
                    }
                    this.updateMessage("Download complete!");
                    this.updateProgress(1L, 1L);
                    MainApp.this.logController.generateLog("INFO", "Xygeni Scanner Download completed");
                    MainApp.this.logController.generateLog("INFO", "Unzipping Xygeni Scanner");
                    this.updateMessage("Unzipping files...");
                    MainApp.unzip(zipPath, baseDir);
                    Files.deleteIfExists(zipPath);
                    MainApp.this.logController.generateLog("INFO", "Xygeni Scanner Unzip completed");
                    if (!isWindows) {
                        try {
                            Path script = Paths.get(nixPath, new String[0]);
                            if (Files.exists(script, new LinkOption[0])) {
                                MainApp.this.logController.generateLog("INFO", "Giving execution rights to Xygeni Scanner");
                                this.updateMessage("Giving execution rights to Xygeni Scanner...");
                                Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
                                Files.setPosixFilePermissions(script, perms);
                            }
                        }
                        catch (UnsupportedOperationException ignored) {
                            MainApp.this.logController.generateLog("WARNING", "Giving execution rights to xygeni scanner failed");
                        }
                    }
                    String resolvedPath = isWindows ? winPath : nixPath;
                    String result = CommandChecker.commandExists("xygeni") ? "xygeni" : resolvedPath;
                    this.updateMessage("Installation was completed correctly");
                    MainApp.this.logController.generateLog("INFO", "Scanner Installation was completed correctly");
                    return result;
                }
                catch (Exception e) {
                    MainApp.this.logController.generateLog("ERROR", "Unhandled exception occurred: " + String.valueOf(e));
                    this.updateMessage("Error during the installation. Please try again");
                    return null;
                }
            }
        };
        if (ctrl instanceof InstallingController) {
            InstallingController installingController = (InstallingController)ctrl;
            downloadTask.messageProperty().addListener((obs, oldVal, newVal) -> installingController.setStepLabelText((String)newVal));
            installingController.setLogController(this.logController);
        }
        downloadTask.setOnSucceeded(arg_0 -> this.lambda$start$4((Task)downloadTask, stage, arg_0));
        downloadTask.setOnFailed(arg_0 -> this.lambda$start$5((Task)downloadTask, stage, arg_0));
        Thread worker = new Thread((Runnable)downloadTask, "xygeni-download-task");
        worker.setDaemon(true);
        worker.start();
    }

    public static void main(String[] args) {
        MainApp.launch((String[])args);
    }

    private /* synthetic */ void lambda$start$5(Task downloadTask, Stage stage, WorkerStateEvent ev) {
        Throwable ex = downloadTask.getException();
        this.logController.generateLog("ERROR", "Downloading failed: " + String.valueOf(ex));
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText("Scanner installation failed");
        alert.setContentText(ex != null ? ex.getMessage() : "Unknown Error");
        alert.initOwner((Window)stage);
        alert.showAndWait();
    }

    private /* synthetic */ void lambda$start$4(Task downloadTask, Stage stage, WorkerStateEvent ev) {
        try {
            String resolvedPath = (String)downloadTask.getValue();
            FXMLLoader mainLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/main-view.fxml"));
            mainLoader.setControllerFactory(type -> {
                if (type == MainController.class) {
                    return new MainController(this.logController);
                }
                try {
                    return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent mainRoot = (Parent)mainLoader.load();
            MainController mainController = (MainController)mainLoader.getController();
            if (resolvedPath != null) {
                mainController.setXygeni_path(resolvedPath);
            }
            Scene mainScene = new Scene(mainRoot, 900.0, 700.0);
            stage.setScene(mainScene);
            double fixedWidth = stage.getWidth();
            stage.widthProperty().addListener((obs, o, n) -> stage.setWidth(fixedWidth));
            this.logController.generateLog("INFO", "Stage Created");
        }
        catch (IOException ioEx) {
            this.logController.generateLog("ERROR", "Cannot load main-view.fxml after install: " + String.valueOf(ioEx));
        }
    }
}

